/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class AutoSmeltEnchant
extends EnchantmentCyclic {
    public static final String ID = "auto_smelt";
    public static ForgeConfigSpec.BooleanValue CFG;

    public AutoSmeltEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_5975_(Enchantment ench) {
        return ench != Enchantments.f_44985_ && ench != Enchantments.f_44987_ && super.m_5975_(ench);
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EnchantAutoSmeltModifier> {
        public EnchantAutoSmeltModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
            return new EnchantAutoSmeltModifier(conditionsIn);
        }

        public JsonObject write(EnchantAutoSmeltModifier instance) {
            return null;
        }
    }

    public static class EnchantAutoSmeltModifier
    extends LootModifier {
        public EnchantAutoSmeltModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public List<ItemStack> doApply(List<ItemStack> originalLoot, LootContext context) {
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
            originalLoot.forEach(stack -> {
                Optional optional = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_());
                if (optional.isPresent()) {
                    ItemStack smeltedItemStack = ((SmeltingRecipe)optional.get()).m_8043_();
                    if (!smeltedItemStack.m_41619_()) {
                        smeltedItemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)smeltedItemStack, (int)(stack.m_41613_() * smeltedItemStack.m_41613_()));
                        newLoot.add(smeltedItemStack);
                    } else {
                        newLoot.add((ItemStack)stack);
                    }
                } else {
                    newLoot.add((ItemStack)stack);
                }
            });
            return newLoot;
        }
    }
}

